<?php
include 'conn.php';

$id = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = (int)$_POST['id'];

  $vards = $conn->real_escape_string($_POST['vards'] ?? '');
  $uzvards = $conn->real_escape_string($_POST['uzvards'] ?? '');
  $dzimene = $conn->real_escape_string($_POST['dzimene'] ?? '');
  $vecums = (int)($_POST['vecums'] ?? 0);

  $intereses_str = $conn->real_escape_string(implode(',', isset($_POST['intereses']) ? $_POST['intereses'] : []));

  $transports = $conn->real_escape_string($_POST['transports'] ?? '');
  $dzimums = $conn->real_escape_string($_POST['dzimums'] ?? '');

  $masinas = '';
  if ($transports == 'Mašīna' && isset($_POST['masinas'])) {
    $masinas = $conn->real_escape_string($_POST['masinas']);
  }

  $update_sql = "UPDATE rihards SET vards = '$vards', uzvards = '$uzvards', dzimene = '$dzimene', vecums = $vecums, intereses = '$intereses_str', transports = '$transports', dzimums = '$dzimums', masinas = '$masinas' WHERE id = $id";

  if ($conn->query($update_sql)) {
    echo "Rediģēja lietotāju " . $vards;
    header("Location: tabula.php");
    exit;
  } else {
    die("Atjaunināšanas kļūda: " . $conn->error);
  }
} else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
  $id = (int)$_GET['id'];
  $query = "SELECT * FROM rihards WHERE id = $id";
  $result = $conn->query($query);

  if (!$result || $result->num_rows === 0) {
    die('Lietotājs ar šo ID netika atrasts.');
  }

  $row = $result->fetch_assoc();
  $intereses = isset($row['intereses']) ? explode(',', $row['intereses']) : [];
  $masinas = $row['masinas'] ?? '';
} else {
  die('Nederīgs pieprasījuma veids.');
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Rediģēt lietotāju</title>
  <script>
    function toggleMasinasField() {
      var transports = document.getElementById("transports").value;
      var masinasField = document.getElementById("masinasField");
      if (transports === "Mašīna") {
        masinasField.style.display = "block";
      } else {
        masinasField.style.display = "none";
      }
    }
  </script>
</head>
<body>
  <h1>Rediģēt lietotāju ar ID: <?= $id ?></h1>
  <form action="edit.php" method="POST">
    <input type="hidden" name="id" value="<?= htmlspecialchars($id) ?>">

    <label for="vards">Vārds:</label><br>
    <input type="text" id="vards" name="vards" required value="<?= htmlspecialchars($row['vards'] ?? '') ?>"><br><br>

    <label for="uzvards">Uzvārds:</label><br>
    <input type="text" id="uzvards" name="uzvards" required value="<?= htmlspecialchars($row['uzvards'] ?? '') ?>"><br><br>

    <label for="dzimene">Dzimene:</label><br>
    <input type="date" id="dzimene" name="dzimene" value="<?= htmlspecialchars($row['dzimene'] ?? '') ?>"><br><br>

    <label for="vecums">Vecums:</label><br>
    <input type="number" id="vecums" name="vecums" min="1" required value="<?= htmlspecialchars($row['vecums'] ?? '') ?>"><br><br>

    <label>Intereses:</label><br>

    <input type="checkbox" id="intereses_sports" name="intereses[]" value="Sports" <?= in_array('Sports', $intereses) ? 'checked' : '' ?>>
    <label for="intereses_sports">Sports</label><br>

    <input type="checkbox" id="intereses_lasisana" name="intereses[]" value="Lasīšana" <?= in_array('Lasīšana', $intereses) ? 'checked' : '' ?>>
    <label for="intereses_lasisana">Lasīšana</label><br>

    <input type="checkbox" id="intereses_dators" name="intereses[]" value="Dators" <?= in_array('Dators', $intereses) ? 'checked' : '' ?>>
    <label for="intereses_dators">Dators</label><br>

    <input type="checkbox" id="intereses_celosana" name="intereses[]" value="Ceļošana" <?= in_array('Ceļošana', $intereses) ? 'checked' : '' ?>>
    <label for="intereses_celosana">Ceļošana</label><br>

    <br>
    <label for="transports">Pārvietošanās veids:</label>
    <select id="transports" name="transports" onchange="toggleMasinasField()" required>
      <option value="Mašīna" <?= ($row['transports'] ?? '') === 'Mašīna' ? 'selected' : '' ?>>Mašīna</option>
      <option value="Vilciens" <?= ($row['transports'] ?? '') === 'Vilciens' ? 'selected' : '' ?>>Vilciens</option>
      <option value="Tramvajs" <?= ($row['transports'] ?? '') === 'Tramvajs' ? 'selected' : '' ?>>Tramvajs</option>
      <option value="Ritenis" <?= ($row['transports'] ?? '') === 'Ritenis' ? 'selected' : '' ?>>Ritenis</option>
      <option value="Lidmašīna" <?= ($row['transports'] ?? '') === 'Lidmašīna' ? 'selected' : '' ?>>Lidmašīna</option>
    </select>

    <br><br>
    <div id="masinasField" style="display: <?= ($row['transports'] === 'Mašīna') ? 'block' : 'none' ?>;">
      <label for="masinas">Mašīnas marka:</label><br>
      <select id="masinas" name="masinas">
        <option value="Audi" <?= ($masinas === 'Audi') ? 'selected' : '' ?>>Audi</option>
        <option value="BMW" <?= ($masinas === 'BMW') ? 'selected' : '' ?>>BMW</option>
        <option value="Opel" <?= ($masinas === 'Opel') ? 'selected' : '' ?>>Opel</option>
        <option value="Mitsubishi" <?= ($masinas === 'Mitsubishi') ? 'selected' : '' ?>>Mitsubishi</option>
        <option value="Toyota" <?= ($masinas === 'Toyota') ? 'selected' : '' ?>>Toyota</option>
        <option value="Honda" <?= ($masinas === 'Honda') ? 'selected' : '' ?>>Honda</option>
        <option value="Hyundai" <?= ($masinas === 'Hyundai') ? 'selected' : '' ?>>Hyundai</option>
        <option value="Mercedes" <?= ($masinas === 'Mercedes') ? 'selected' : '' ?>>Mercedes</option>
        <option value="Pagani" <?= ($masinas === 'Pagani') ? 'selected' : '' ?>>Pagani</option>
        <option value="Koenigsegg" <?= ($masinas === 'Koenigsegg') ? 'selected' : '' ?>>Koenigsegg</option>
        <option value="Peel" <?= ($masinas === 'Peel') ? 'selected' : '' ?>>Peel</option>
        <option value="Ford" <?= ($masinas === 'Ford') ? 'selected' : '' ?>>Ford</option>
      </select><br><br>
    </div>

    <label for="dzimums">Dzimums</label>
    <select id="dzimums" name="dzimums">
      <option value="Vīrietis" <?= ($row['dzimums'] ?? '') === 'Vīrietis' ? 'selected' : '' ?>>Vīrietis</option>
      <option value="Sieviete" <?= ($row['dzimums'] ?? '') === 'Sieviete' ? 'selected' : '' ?>>Sieviete</option>
      <option value="Neteikšu" <?= ($row['dzimums'] ?? '') === 'Neteikšu' ? 'selected' : '' ?>>Neteikšu</option>
    </select>

    <br><br>
    <button type="submit">Saglabāt</button>
  </form>
</body>
</html>
